///////////////////////////////////////////////////////////////////////////////
//
//   CONEXANT SYSTEMS INC - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1337.C - Message 1337 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1337 messages.
//
//
//   REVISION HISTORY
//
//   Initial release to version control.
//
//   $Log:   V:\Projects\Labmon\Source\Archives\msg1337.c_v  $ 
//   
//      Rev 1.0   08 Dec 1999 14:42:46   dangmk
//    
//
//
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"
#include "util.h"   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1337 message from the ZMsgBuf.
//
//void Dec1337(tMSGBUF *ZMsgBuf, tMSG1337 *Msg)
//{

//}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1337 message in the ZMsgBuf. 
//
void Bld1337(tMSGBUF *ZMsgBuf, tMSG1337 *Msg)
{
   // copy message into buffer
   memcpy(((tSHORT *) ZMsgBuf)+5, Msg, sizeof(*Msg));          

   // build the header in the buffer
   PutShort  (0x81FF                        , ZMsgBuf, 1);     // message preamble
   PutShort  (1337                          , ZMsgBuf, 2);     // message number
   PutShort  (131                           , ZMsgBuf, 3);     // message length 
   PutShort  (ANREQ                         , ZMsgBuf, 4);     // message ack/nack request
}
